#define F1 "bigbefore2272x1704.raw"
#define F2 "bigmain2272x1704.raw"
//#define F2 "bugsimulation.raw"
#define F3 "bigafter2272x1704.raw"

#define XSIZE 2272	/* Test image width */
#define YSIZE 1704	/* Test image height */
#define COLOUR 0 /* Greyscale image */


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>
#include <time.h>

#define XP printf

static void ndx2rgb(unsigned ndx,int *rp,int *gp,int *bp);

enum {FALSECOLOUR=0,MONO};

#ifndef M_PI
 #define M_PI 3.14159265
#endif

/************************* main *************************/

main()
{
int i,j,x,y;
unsigned mono;
unsigned char *p1,*p2,*p3,*p4,*pc;
unsigned char *p,*q,*s,*t;
FILE *fp;

/* Allocate memory for image buffer */

	if ((p1=malloc(XSIZE*YSIZE))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

	if ((p2=malloc(XSIZE*YSIZE))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

	if ((p3=malloc(XSIZE*YSIZE))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

	if ((p4=malloc(XSIZE*YSIZE))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

	if ((pc=malloc(XSIZE*YSIZE*3))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

	mono = 1;

/* Load images */

	if ((fp = fopen(F1,"rb")) == NULL) {
		XP("Cannot open file 1\n");
		return 0;
		}
	XP("Read %d bytes\n",fread(p1,1,XSIZE*YSIZE,fp));
	fclose(fp);


	if ((fp = fopen(F2,"rb")) == NULL) {
		XP("Cannot open file 2\n");
		return 0;
		}
	XP("Read %d bytes\n",fread(p2,1,XSIZE*YSIZE,fp));
	fclose(fp);


	if ((fp = fopen(F3,"rb")) == NULL) {
		XP("Cannot open file 3\n");
		return 0;
		}

	XP("Read %d bytes\n",fread(p3,1,XSIZE*YSIZE,fp));
	fclose(fp);

/* Add simulated test streak to main image for control purposes */

	simstreak(p2);	/**/

/* Add a test grid */

	addgrid(p2);	/**/

/* Compute diffs between before and after images */

#if 0 /* Diff before and centre */
	p = p1;
	q = p2;
	t = p4;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			i = *q++;
			i = i+128-*p++;
			*t++ = i;
			}
		}

	stretch_image(p4);

	if (mono)
		write_image("diffbm.raw",p4,MONO);
	else {
		false_colour(p4,pc);
		write_image("diffbm.raw",pc,COLOUR);
		}


#endif

#if 0 /* Diff centre and after */

	p = p2;
	q = p3;
	t=p4;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			i = *p++;
			i = i+128-*q++;
			*t++ = i;
			}
		}
	stretch_image(p4);
	if (mono)
		write_image("diffma.raw",p4,MONO);
	else {
		false_colour(p4,pc);
		write_image("diffma.raw",pc,COLOUR);
		}
#endif

#if 0 /* Diff before and after */

	p = p1;
	q = p3;
	t = p4;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			i = *q++;
			i = i+128-*p++;
			*t++ = i;
			}
		}
	stretch_image(p4);

	if (mono)
		write_image("diffba.raw",p4,MONO);
	else {
		false_colour(p4,pc);
		write_image("diffba.raw",pc,COLOUR);
		}

#endif

#if 1 /* Sum before and after, diff against middle */
	p = p1;
	q = p3;
	s = p2;
	t = p4;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			i = (unsigned int) *p++;
			i += (unsigned int) *q++;
#if 0 /* Original method */
			i = (unsigned) *s++ + 128 - i/2;
#else /* 16-Dec-2004: saves divides and scales difference by 2 */
			j = *s++;
			i = j+j-i+128;
			if (i<0)
				i=0;
			else if (i>255)
				i=255;
#endif
			*t++ = i;
			}
		}

//	stretch_image(p4);
#if 0
	if (mono)
		write_image("diffbam.raw",p4,MONO);
	else {
		false_colour(p4,pc);
		write_image("diffbam.raw",pc,COLOUR);
		}
#endif
#endif


#if 0 /* Write out (modified) original image */
	if (mono)
		write_image("x1.raw",p2,MONO);
	else {
		false_colour(p2,pc);
		write_image("x1.raw",pc,COLOUR);
		}
#endif


/* Extract part of image containing trail to file */

	trail2file(p4);

	return 0;
}
/************************* stretch_image *************************/

/* Define image area to use when computing scaling factor */

#if 0
 #define XOFF 374
 #define YOFF 521
 #define XLEN 714
 #define YLEN 473
#else
 #define XOFF 781
 #define YOFF 852
 #define XLEN 333
 #define YLEN 125
#endif

int stretch_image(unsigned char *imgptr)
{
int i,j,x,y,min,max;
unsigned char *p;
double z,avg,scale;

	p = imgptr;

	z = 0.0;
	min = 255;
	max = 0;

/* Find min, max and average values */

	for (y=YOFF;y<YOFF+YLEN;y++) {

		p = imgptr + y*XSIZE+XOFF;

		for (x=XOFF;x<XOFF+XLEN;x++) {

			if ((i=*p++) < min)
				min=i;
			else if (i > max)
				max = i;
			z += i;
			}
		}

	avg = z/(YLEN*XLEN);

	scale = 255.0/(max-min);

//scale /=2.0;
scale *= 2.0;
//scale *=4.0;
//scale *=20.0;

	XP("Average %.3lf  Min %3u Max %3u  Scale %.3lf\n",avg,min,max,scale);

/* Rescale the entire image */

	p = imgptr;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			z = *p;
			z = z-avg;
			z *= scale; /*Scale */
			z += 128;
			if (z<0.0)
				*p++=0;
			else if (z>255)
				*p++=255;
			else
				*p++=z;
			}
		}

	return 1;
}
/************************* simstreak *************************/

/* Adds a simulated streak parallel to the actual mystery streak (for use as a control) */

#define XSIMO 170
#define YSIMO 350	/* Originally 340 */

#define ALPHA (200.0/255.0)	/* Streak density: use 251.0 for reasonable fit to image */

#define TOFF (25)	/* Originally zero, but trail hit horizon */

int simstreak(unsigned char *imgptr)
{
int i,j,k,len,x,y,yb4,min,max;
unsigned char *s;
double z,v,avg,scale,sina,cosa;

#define SIMANGLE (33.6/180.0*3.14159)
#define SIMWIDTH 27

	sina=sin(SIMANGLE);
	cosa=cos(SIMANGLE);

	len = SIMWIDTH/cos(SIMANGLE+3.14159/2);
	len=abs(len);

	yb4=0;
	for (i=0;i<1180;i++) {
		x = (double) (i-TOFF) * cosa + XSIMO;
		y = (double) (i-TOFF) * sina + YSIMO;

		if (y != yb4) {
			s = imgptr+(y*XSIZE+x);
			for (j=0;j<len;j++) {
				z = (double) (2*j-len)/(double)len;
				z*=3.14159;
				z = -cos(z)/2.0+0.5;	/* Range 0 to 1.0 */

				k = *s;	/* Get pixel value (0 to 255) */
				k = (k<<8)+(rand()&255);	/* Scale up by 256, add noise */
				v = (double)k;
				v = v*ALPHA + (z*v)*(1.0-ALPHA);
				k = v;
				k>>=8;
//if (y==400)
// XP("%2u: %.2lf %.2lf\n",j,z,v);
				*s++=k;
				}
			}
		yb4=y;
		}

	return 1;
}
/************************* addgrid *************************/

/* Hack: add a test grid with (about) the same orientation as the trail */

#define XGO 180
#define YGO 360

int addgrid(unsigned char *imgptr)
{
int i,j,len,x,y,mx,my,yb4,min,max;
unsigned char *s;
double z,v,avg,scale,sina,cosa;

#define GRIDANGLE (33.6/180.0*3.14159)
#define GOFF 0	/* Offset (to slide grid back and forth along line) */

	sina=sin(GRIDANGLE);
	cosa=cos(GRIDANGLE);

	len = 100;	/* Grid width */

	yb4=0;
	for (i=0;i<1180;i++) {

		x = (double) (i-GOFF) * cosa + XSIMO;
		y = (double) (i-GOFF) * sina + YSIMO;

		if (y != yb4) {

			s = imgptr+(y*XSIZE+x);
			*s++=0;
			*s++=0;

			}

		if (i%20==0) {
			for (j=0;j<len;j++) {
				mx = x + (double) (j-len/2)*cos(GRIDANGLE+M_PI/2.0);
				my = y + (double) (j-len/2)*sin(GRIDANGLE+M_PI/2.0);
				s = imgptr+(my*XSIZE+mx);
				*s=0;
				}
			}

		yb4=y;
		}

	return 1;
}
/************************* false_colour *************************/

int false_colour(unsigned char *pin,unsigned char *pout)
{
unsigned i,x,y,r,g,b;
unsigned char *s,*t;

	s = pin;
	t = pout;
	for (y=0;y<YSIZE;y++) {
		for (x=0;x<XSIZE;x++) {
			i = *s++;
//i-=50;
			ndx2rgb(i,&r,&g,&b);
			*t++=r;
			*t++=g;
			*t++=b;
			}
		}
	return 0;
}
/************************* write_image *************************/

int write_image(char *name,char *p,unsigned mode)
{
unsigned n;
FILE *fp;

	if ((fp = fopen(name,"wb")) == NULL) {
		XP("Write Image error: Can't open %s\n",name);
		exit(1);
		}

	if (mode==MONO)
		n = XSIZE*YSIZE;
	else
		n = XSIZE*YSIZE*3;

	if (fwrite(p,1,n,fp) != n)
		XP("Error writing file %s\n",name);

	fclose(fp);

	return 1;

}

/************************* ndx2rgb *************************/

/* Convert the given index into false-colour RGB value */

static void ndx2rgb(unsigned ndx,int *rp,int *gp,int *bp)
{
unsigned j;
unsigned char *p;
double x,r,g,b;

	ndx %= 256;	/* Sanity - Force into legal range */

	r = g = b = 0.0;

#if 0 /* Hack...add to offset start position so it doesn't begin with black */
 ndx=(double) ndx/255.0*(255-25)+25;
#endif

	j = ndx/51 * 51;

	x = (double) (ndx-j+1)/51.0;

	switch (j) {

		case 0:	/* Black to blue */
			x = (double) (ndx-j)/50.0;
			r=0.0;
			g=0.0;
			b=x;
			break;

		case 51*1: /* Blue to green */
			b=1.0-x;
			g=x;
			r=0.0;
			break;

		case 51*2:	/* Green to red */
			b=0.0;
			g=1.0-x;
			r=x;
			break;

		case 51*3:	/* Red to Yellow */
			b=0.0;
			g=x*50.0/51.0;
			r=1.0;
			break;

		case 51*4:	/* Yellow to white (note last 10 colours not available) */
			x = (double) (ndx-j)/(51.0-10.0);
			if (x>1.0)
				x=1.0;
			b=x;
			g=1.0;
			r=1.0;
			break;

		case 51*5:
			r = g = b = 1.0;
			break;

		default:
			XP("ERROR: Bad case %u\n",j);
			break;
		}

	*rp = r*255.0;
	*gp = g*255.0;
	*bp = b*255.0;

/* We want to avoid any colours with the same value as system colours, else we don't
   get an identity palette. Maybe there's another way around this, but for now we just
   frig the values to avoid the system colours */

	if (*bp<255)
		 (*bp)++;

	if (*rp<255)
		(*rp)++;

	if (*rp==*gp && *rp==*bp && *rp==255)	/* Avoid 255,255,255 */
		(*bp)--;
}

/************************* trail2file *************************/

/* 
 Extract a portion of the image containing the trail to a file. To make things
 easy to process we want the trail horizontal, but a rotation could introduce
 artifacts (depending on filtering etc). So as a check we extract the trail
 using horizontal and vertical shears, which requires no filtering and uses
 each pixel exactly once.
*/

/* Trail start position and angle */

#define TSTARTX 170
#define TSTARTY 275 
#define ANGLE (33.6/180.0*M_PI)

/* Input image size */

#define IMGXSIZE XSIZE
#define IMGYSIZE YSIZE

/* Output image size */

#define OXSIZE 1250
#define OYSIZE 200

#define XPRE 150		/* OYSIZE*tan(M_PI/4-ANGLE)/2 */
#define XPOST 150

#define OXTOTAL (XPRE+OXSIZE+XPOST)

int trail2file(unsigned char *imgptr)
{
int i,j,x,y;
unsigned char *s,*t,*op;
double tana;
FILE *fp;

	if ((op=malloc(OXTOTAL*OYSIZE))==NULL) {
		XP("malloc() failed\n");
		exit(1);
		}

/* Proceeding on X, pull out 'nx' vertical strips each OYSIZE pixels tall */

	tana = tan(ANGLE);

	for (i=0;i<OXTOTAL;i++) {

		x = i + TSTARTX - XPRE;

		y = (double) i * tana + TSTARTY - OYSIZE/2;

//XP("Trail x %3u  y %3u\n",i+TSTARTX,(int)((double)i*tana)+TSTARTY); /**/

		s = imgptr + y*IMGXSIZE+x;
		t = op+i;

		for (j=0;j<OYSIZE;j++) {
			*t=*s;
			s += IMGXSIZE;
			t += OXTOTAL;
			}
		}

/*
 Now proceeding on Y, shift each strip sideways so pixels perpendicular to
 the trail are back in line
*/

#define XANGLE (M_PI/2.0-ANGLE-ANGLE)

	for (i=0;i<OYSIZE;i++) {

		x = i; // somefunctionof(i)

		s = op+i*OXTOTAL;
		t = s+x;

		memmove(t,s,OXTOTAL-x);
//XP("%3u -> %.2lf\n",i,(double)i*somefunc()); /**/
//*t++=0;
//*t++=0;
		}

/* Done - write data to file */

	if ((fp = fopen("x.raw","wb"))==NULL) {
		XP("Failed to open output file\n");
		exit(1);
		}

	for (y=0;y<OYSIZE;y++) {

		s = op+y*OXTOTAL; //+XPRE;

		fwrite(s,1,OXSIZE,fp);
		}

	fclose(fp);

	free(op);

	XP("trail2file() complete\n");

	return 1;
}
