/*
 Hack program to process APOD image of 7-Dec-2004 (based on code
 used to process scans of old maps).

 Reads images in 24-bit raw format (, the dimensions are hardcoded below), displays
 the image and processes it in various ways.

 Never intended for public release; it was expected this code would be thrown away
 after processing the APOD images. However requests have been made for the release
 of this code, and it is therefore released as GPL code (www.gnu.org).

 No warranties whatsoever.

 For additional information see http://hazeii.net/apod

 Copyright (c) N Newell 2004 unless otherwise noted.

 Initial release version: 0.0.1 19-Dec-2004

*/

/* Filename and dimensions of image in disk file */
#if 0
 #define FILENAME "map3308x2450.raw" /**/
 #define IMGX 3308	/* Test image width */
 #define IMGY 2450	/* Test image height */
 #define COLOUR 1
#elif 0
 #define FILENAME "/pub/trail1144x84.raw" /**/
 #define IMGX 1144	/* Test image width */
 #define IMGY 84	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail977x218.raw" /**/
 #define IMGX 977	/* Test image width */
 #define IMGY 218	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail1180x182.raw" /**/
 #define IMGX 1180	/* Test image width */
 #define IMGY 182	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail1193x209.raw" /**/
 #define IMGX 1193	/* Test image width */
 #define IMGY 209	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail581x255.raw" /**/
 #define IMGX 581	/* Test image width */
 #define IMGY 255	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail1203x361.raw" /**/
 #define IMGX 1203	/* Test image width */
 #define IMGY 361	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/trail1024x200.raw" /**/
 #define IMGX 1024	/* Test image width */
 #define IMGY 200	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/greydiff1662x1544-33d0.raw" /* 33 degree rotation */
 #define IMGX 1662	/* Test image width */
 #define IMGY 1544	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/greydiff1358x960-33d6.raw" /* MAIN IMAGE USED ON APOD*/
 #define IMGX 1358	/* Test image width */
 #define IMGY 960	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 0
 #define FILENAME "/pub/greyrods1024x58.raw" /**/
 #define IMGX 1024	/* Test image width */
 #define IMGY 58	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 1
 #define FILENAME "/pub/map/x.raw" /**/
 #define IMGX 1250	/* Test image width */
 #define IMGY 200	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#elif 1
 #define FILENAME "dr3600x2700.raw" /**/
/* #define FILENAME "dr3600x2700sim.raw" /**/
/* #define FILENAME "dr3600x2700bugsim.raw" /**/
 #define IMGX 3600	/* Test image width */
 #define IMGY 2700	/* Test image height */
 #define XSTART 227
 #define YSTART 466
// #define XSTART 227 /* For simulated image */
// #define YSTART 443

 #define COLOUR 0 /* Greyscale image */
#else
 #define FILENAME "/pub/greydiff2184x1544-33d8.raw" /* */
 #define IMGX 2184	/* Test image width */
 #define IMGY 1544	/* Test image height */
 #define COLOUR 0 /* Greyscale image */
#endif

/* 76,131 for main APOD image */

#ifndef XSTART
 #define XSTART  0//76 // 1600 // 500
 #define YSTART  0//131 // 1438 // 1038
#endif

/* Display window size */

#define XSIZE  1000 // 1270 // 250 // (1280-20)			/* Required X dimension */
#define YSIZE  120 // 200 // 250 // (1024-50)			/* Required Y dimension */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>
#include <time.h>

//#include "map.h"

static struct {
	int width;
	int height;
	unsigned char *dsptr;
	unsigned char *backptr;
	} gd;

#define CTL(x) (x&31)

/* Local Prototypes */

void redraw();

#define XP printf

void ttyout(char c);
void putstr(char *p);

static int map_read(unsigned x,unsigned y,unsigned xsize,unsigned ysize,unsigned buffwidth,unsigned buffheight,unsigned char *buff);

unsigned char *imgbuff;

int cortest(double factor,int xsize,int ysize,unsigned char *pdata);
int bugtest(int xsize,int ysize,int xlimit,unsigned char *pdata);

/************************* main *************************/

static unsigned run,paused;

main()
{
int i,j,x,y,mangle,dobug,doautocor,xlimit;
unsigned char *p,buff[200];
unsigned recolour[3]={0x60,0xb0,0xf4};	/* Light blue grid lines */
//unsigned recolour[3]={0xf7,0x70,0xa0}; /* Red footpasth/bridleway lines */
double acfactor;

/* Start graphics and create display window */

	gfxon();

	getxysize(&x,&y);

	printf("Window xsize, ysize %u %u\n",x,y);

/* Allocate memory for image buffer */

	if ((imgbuff=malloc(XSIZE*YSIZE*3))==NULL) {
		XP("Unable to allocate image data buffer\n");
		exit(1);
		}

/* Open the file */

	if (map_open(FILENAME)==0) {
		exit(1);
		}

/* Main loop */

	run = 1;

X_color(1);

dobug=doautocor=0;
acfactor=2.5;

/* Set initial image position */

		x = XSTART;
		y = YSTART;

/* Main loop */

	mangle = 0;

	while (run) {

		set_recolour(recolour[0],recolour[1],recolour[2]);

		map_read(x,y,IMGX,IMGY,XSIZE,YSIZE,imgbuff);

		xlimit = XSIZE-35;	/* Horizontal distance to process over */

		if (doautocor) {
			cortest(acfactor,XSIZE,YSIZE,imgbuff);
			xlimit = XSIZE/acfactor;
			}

		if (dobug)
			bugtest(XSIZE,YSIZE,xlimit,imgbuff);

		test(XSIZE,YSIZE,imgbuff,mangle);

		sprintf(buff,"Image position = %u,%u",x,y);
		X_string(buff,150);
		paint();

		while ((i=getkey()) <= 0)
			;

		while (i >= 0) {

			if (i == 0x1b) {
				run = 0;
				break;
				}

//XP("Key 0x%x  CTLB = 0x%x\n",i,CTL('B'));
#define SPIX 1
			if (i==CTL('B'))
				x=x>SPIX?x-SPIX:0;
			else if (i==CTL('F'))
				x=x+SPIX<IMGX-XSIZE?x+SPIX:IMGX-XSIZE;
			else if (i==CTL('P'))
				y=y>SPIX?y-SPIX:0;
			else if (i==CTL('N'))
				y=y+SPIX<IMGY-YSIZE?y+SPIX:IMGY-YSIZE;

			if (i=='+')
				;
			else if (i=='-')
				;
			if (i=='>') {
				if (acfactor >= 1.1)
					acfactor -= 0.1;
				XP("AC Factor %0.2lf\n",acfactor);
				}
			else if (i=='<') {
				acfactor += 0.1;
				XP("AC Factor %0.2lf\n",acfactor);
				}
			else if (i=='t')
				;
			else if (i=='#')
				dobug=!dobug;
			else if (i=='c')
				doautocor=!doautocor;

			if (i=='z')	/* Reset all image transform options? */
				mangle=0;
			else if (i=='m')	/* Greyscale */
				mangle^=1;
			else if (i=='h')	/* Horizontal edge */
				mangle^=2;
			else if (i=='v')	/* Vertical edge */
				mangle^=4;
#if 0
			else if (i=='x')	/* Convolution filter */
				mangle^=8;
#endif
			else if (i=='f')	/* False colour */
				mangle^=16;

			else if (i=='*') {
				X_locator(&i,&j);
				if (i>=0 && i < XSIZE && j >= 0 && j < YSIZE) {
					printf("Mouse at %u,%u",i,j);
					p = imgbuff + (i+(YSIZE-1-j)*XSIZE)*3;
					XP("  R: 0x%02x ",*p++);
					XP("G: 0x%02x ",*p++);
					XP("B: 0x%02x ",*p++);
					XP("\n");
					}
				}

/* Modify target colourRGB values */

			if (i=='r'&&recolour[0]>0)
				recolour[0]--;
			else if (i=='R'&&recolour[0]<255)
				recolour[0]++;

			if (i=='g'&&recolour[1]>0)
				recolour[1]--;
			else if (i=='G'&&recolour[1]<255)
				recolour[1]++;

			if (i=='b'&&recolour[2]>0)
				recolour[2]--;
			else if (i=='B'&&recolour[2]<255)
				recolour[2]++;

/* Check for another key */

			i = getkey();
			}
		}

/* Program terminating - shut down graphics and exit */

	gfxoff();

	XP("\nProgram terminated\n");
}

#if 0
graphmode(int mode)
{
	return gfxmode = mode;
}
getgraphmode(e)
{
	return gfxmode;
}
#endif
/**************************** key handling *********************************/

static unsigned char keybuff[50];
static unsigned int keyput;
static unsigned int keyget;

putkey(unsigned char c)
{
	keybuff[keyput] = c;

	if (++keyput >= sizeof(keybuff))
		keyput = 0;

	if (keyput == keyget)
		if (++keyget >= sizeof(keybuff))
			keyget = 0;
}

getkey()
{
unsigned char c;

	if (os_scan() < 0)
		run = 0;

	if (keyput == keyget) {
		sched_yield();
		return -1;
		}

	c = keybuff[keyget];

	if (++keyget >= sizeof(keybuff))
		keyget = 0;

	return c;
}


/**************** os_scan *****************/

/* Routine called from main() application */

os_scan()
{
	X_check_keypress();

	return 0;
}

/******************** paint ************************/
paint()
{
int i,x,y;
unsigned char buff[256];
unsigned char *p,*s,points[1024];

//	gfxcolumn(points,y);

	statusbar(1);

	gfxpaint();

	X_update(1);
	X_clear();

	return 1;
}
/************************* blit *******************************/

blit(unsigned x,unsigned y,unsigned xsize,unsigned ysize,unsigned char *ptr)
{
unsigned i;
unsigned char *p;

/* Validate/clip X */

	if (x >= gd.width)
		return 0;

	if (x+xsize > gd.width)
		xsize = gd.width - x;

/* Validate/clip Y */

	if (y >= gd.height)
		return 0;

	if (y+ysize > gd.height)
		ysize = gd.height - y;

/* Blit data into bitmap buffer */

	p = gd.dsptr + y*gd.width + x;

/*XP("X,Y %d %d Size %d %d  Index %d  %p/%p %p\n",x,y,xsize,ysize,y*gd.width+x,gd.dsptr,p,ptr); /**/

	for (i=0;i<ysize;i++) {
		memcpy(p,ptr,xsize); /**/
		p += gd.width;
		ptr += xsize;
		}

	return 1;
}
/********************** vline ************************/

vline(unsigned sx,unsigned sy,unsigned ylen,unsigned colour)
{
int i;
unsigned char *p;

/* Validate/clip X */

	if (sx >= gd.width)
		return 0;

/* Validate/clip Y */

	if (sy >= gd.height)
		return 0;

	if (sy+ylen > gd.height)
		ylen = gd.height - sy;

/* Draw the line */

	p = gd.dsptr + sy*gd.width + sx;

	for (i=0;i<ylen;i++) {
		*p = colour; /**/
		p+= gd.width;
		}

	return 1;
}
/********************** hline ************************/

hline(unsigned sx,unsigned sy,unsigned xlen,unsigned colour)
{
int i;
unsigned char *p;

/* Validate/clip X */

	if (sx >= gd.width)
		return 0;

	if (sx+xlen > gd.width)
		xlen = gd.width-sx;

/*XP("SX %u  gd.width %u  sx+xlen %u\n",sx,gd.width,sx+xlen);  /**/

/* Validate Y */

	if (sy >= gd.height)
		return 0;

/* Draw the line */

	p = gd.dsptr + sy*gd.width + sx;

	memset(p,colour,xlen); /**/

	return 1;
}
/************************ plot ***********************/

plot(unsigned sx,unsigned sy,unsigned colour)
{

/* Validate pixel position */

	if (sx >= gd.width || sy >= gd.height)
		return 0;

/* Plot the point */

	*(gd.dsptr + sy*gd.width + sx) = colour;

	return 1;
}

/************************** getxysize ***************************/

getxysize(unsigned int *xp, unsigned int *yp)
{
	*xp = gd.width;
	*yp = gd.height;
}
/************************** getcharsize ***************************/

getcharsize(unsigned int *xp, unsigned int *yp)
{
	*xp = 8;
	*yp = 16;
}
/************************* clear_text ************************/
clear_text()
{
//	memset(screen,' ',sizeof(screen));
	return 1;
}
/*************************** clear_screen *********************/
clear_screen()
{
	if (gd.dsptr != NULL)
		memset(gd.dsptr,0,gd.width*gd.height);

	return 1;
}
/********************** putstr ***********************/
void putstr(char * str)
{
	while (*str)
		ttyout(*str++);
}
/************************* ttyout **************************/
void ttyout(char c)
{
	XP("%c",c);
}
/***************************** XP **********************************/

void __XP(char *fmt,...)
{
int i;
va_list argptr;
char c,*p,buff[500];

/* Create string in buffer */

	va_start(argptr,fmt);	/* Initialize variable argument list */

	vsprintf(buff,fmt,argptr);	/* Print string with variable arg. list */

	printf(buff);

	va_end(argptr);		/* Clean up argument list */

	return;
}
/* ============================ */

gfxon()
{
int x,y;

	x = XSIZE;
	y = YSIZE;
	gd.width = x;
	gd.height = y;
	gd.dsptr = malloc(x*y);
	X_init();
	X_clear();
	X_backbuf();

}
gfxoff()
{
	X_exit();
}
/* ================================================== */

static FILE *fp;

int map_open(unsigned char *fname)
{
	if (fp != NULL) {
		fclose(fp);
		fp = NULL;
		}

	if ((fp = fopen(fname,"rb")) == NULL) {
		XP("Cannot open file %s\n",fname);
		return 0;
		}

XP("Opened image file %s\n",fname);

	return 1;

}

static int map_read(unsigned x,unsigned y,unsigned xsize,unsigned ysize,unsigned width,unsigned height,unsigned char *buff)
{
int i,j,k,buffsize;
unsigned index,maxndx;
unsigned char *p,*s,*t;

	maxndx = xsize*ysize*3;		/* Total 24-bit pixels in image */

	index = (y*xsize+x)*3;		/* Start read point */

XP("Image offset: X %u Y %u\n",x,y);
/*XP("Window Height: %u  File y dimension: %u\n",height,ysize); /**/

/* TODO: zero out any unread parts of the buffer? */

	if (index >= maxndx)
		return 0;

	p = buff;
	fseek(fp,index,SEEK_SET);
#if COLOUR
	for (i=0;i<height;i++) {
		if ((j = fread(p,1,width*3,fp))<=0)
			break;
		p+=width*3;
		index += xsize*3;
		fseek(fp,index,SEEK_SET);
		}
#else /* For raw greyscale images, replicate each byte 3 times */
	for (i=0;i<height;i++) {
		if ((j = fread(p,1,width,fp))<=0)
			break;

		s=p+width;	/* Replicate each byte 3 times */
		t=p+width*3;
		for (k=0;k<width;k++) {
			*--t=*--s;
			*--t=*s;
			*--t=*s;
			}
		p+=width*3;
		index += xsize;
		fseek(fp,index,SEEK_SET);
		}
//XP("Final index %u\n",index);
#endif

	return 1;
}


int map_close()
{
	if (fp != NULL)
		fclose(fp);
	fp = NULL;

	return 1;
}
